import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(9, 12))

# Define colors
floor_color = 'lightgrey'
passenger_color = 'blue'
fast_elevator_color = 'green'
slow_elevator_color = 'orange'
text_color = 'black'

# Define floor positions and sizes
floor_height = 1
floor_width = 10
num_floors = 5
floor_gap = 1.5  # Gap between floors

# Draw floors
for i in range(num_floors):
    ax.add_patch(patches.Rectangle((0, i * floor_gap), floor_width, floor_height, color=floor_color))
    ax.text(0.2, i * floor_gap + 0.5, f'floor_{i}', fontsize=12, va='center', ha='left', color=text_color)

# Draw passengers
passengers = {
    'p2': (0, 0), 'p3': (0.5, 0),
    'p0': (0, 1), 'p5': (0.5, 1),
    'p1': (0, 3), 'p4': (0.5, 3)
}

for p, (x_offset, floor) in passengers.items():
    ax.add_patch(patches.Rectangle((x_offset, floor * floor_gap + 0.25), 0.3, 0.5, color=passenger_color))
    ax.text(x_offset + 0.15, floor * floor_gap + 0.5, p, fontsize=10, va='center', ha='center', color='white')

# Draw elevators
elevators = {
    'fast0': (8, 0, fast_elevator_color, '0/2'),
    'fast1': (9, 0, fast_elevator_color, '0/2'),
    'slow0-0': (7, 0, slow_elevator_color, '0/1'),
    'slow1-0': (7, 2, slow_elevator_color, '0/1')
}

for e, (x, floor, color, status) in elevators.items():
    ax.add_patch(patches.Rectangle((x, floor * floor_gap + 0.25), 0.8, 0.5, color=color))
    ax.text(x + 0.4, floor * floor_gap + 0.5, f'{e}\n{status}', fontsize=10, va='center', ha='center', color='white')

# Add legend
legend_patches = [
    patches.Patch(color=passenger_color, label='Passenger'),
    patches.Patch(color=fast_elevator_color, label='Fast Elevator'),
    patches.Patch(color=slow_elevator_color, label='Slow Elevator')
]
ax.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and remove axes
ax.set_xlim(-0.5, 11)
ax.set_ylim(-0.5, num_floors * floor_gap)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_28.png', bbox_inches='tight')
plt.show()